/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: UString.cpp,v 1.1 1999/09/12 04:24:10 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include <stdio.h>

#include "UString.h"

_USING_PGP

// Functions

// SmartStringCopy copies either 'inString' in its entirety to 'outString', 
// or 'outBufSize' chars of 'inString', whichever is smaller, and appends a 
// null character.

void 
UString::SmartStringCopy(
	char		*outString, 
	const char	*inString, 
	PGPUInt32	outBufSize)
{
	PGPUInt16	numToCopy;

	pgpAssertAddrValid(outString, char);
	pgpAssertStrValid(inString);

	numToCopy = pgpMin(strlen(inString), outBufSize - 1);

	strncpy(outString, inString, numToCopy);
	outString[numToCopy] = '\0';
}
